﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class NoiseGen : UserControl
    {

        private NoiseGenerator Noise;

        public NoiseGen()
        {
            InitializeComponent();
            this.EnabledChanged += new EventHandler(NoiseCtrl_EnabledChanged);
            level_Noise.SignalLevelChanged += new EventHandler(level_Noise_SignalLevelChanged);
        }

        /// <summary>
        /// This updates the noise generate level when the user changed the value entered
        /// </summary>
        void level_Noise_SignalLevelChanged(object sender, EventArgs e)
        {
            try
            {
                if (Noise == null) return;
                Noise.Level = level_Noise.Level;
            }
            catch { }
        }

        void NoiseCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = Enabled;
        }

        public void SetGenerator(NoiseGenerator Gen)
        {
            this.Noise = Gen;
            RefreshControls();
            UpdateStatus();
            timer_Update.Interval = 500;
        }

        private void RefreshControls()
        {
            try
            {
                if (Noise == null) return;
                level_Noise.Level = Noise.Level;
            }
            catch { }
        }

        private void UpdateStatus()
        {
            try
            {
                if (Noise == null) return;
                if (Noise.IsActive)
                {
                    cb_Noise.Text = "White Noise (Active)";
                }
                else
                {
                    cb_Noise.Text = "White Noise";
                }
            }
            catch { }
        }

        private void NoiseCtrl_Load(object sender, EventArgs e)
        {

        }

        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                Noise.Generate(level_Noise.Level);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();
            }
        }

        private void btn_Stop_Click(object sender, EventArgs e)
        {
            try
            {
                Noise.StopGenerator();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();
            }
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            UpdateStatus();
        }




    }
}
